#ifndef LIBACP_LIBACPERR_H_
#define LIBACP_LIBACPERR_H_

enum AcpErrors {
  ACP_ERR_SUCCESS = 0x0000,

  // 通讯状态的变化
  ACP_ERR_CONN_SUCCESS = 0x0001,     // 连接成功
  ACP_ERR_CONN_PENDING = 0x0002,     // 正在连接
  ACP_ERR_NO_CONN = 0x0003,          // 未连接
  ACP_ERR_CONN_REFUSED = 0x0004,     // 拒绝连接
  ACP_ERR_CONN_LOST = 0x0005,        // 断开连接
  ACP_ERR_CONN_TIMEOUT = 0x0006,     // 连接超时
  ACP_ERR_HOSTUNREACHABLE = 0x0007,  // Host unreachable
  ACP_ERR_AUTH_CONTINUE = 0x0008,    // 需要权限认证

  // 基础通讯协议类的错误
  ACP_ERR_INVALID_ACPDEVICEID = 0x1001,  // 无效的AcpDeviceId
  ACP_ERR_INVAILD_IDGROUP,               // 无效的id group
  ACP_ERR_INVAILD_IDOFFSET,              // 无效的id offset
  ACP_ERR_INVAILD_DATAPACKAGE_LEN,       // 无效的数据包长度
  ACP_ERR_INVAILD_PORT,                  // 无效的port port号1-65535
  ACP_ERR_PORT_UNREGISTER,               // 路由port未注册
  ACP_ERR_PORT_ALREADY_REGISTER,         // 路由port号已经被注册了
  ACP_ERR_MESSAGE_TIMEOUT,               // 消息超时
  ACP_ERR_UNKNOWN_CMDID,                 // 未知的CmdId
  ACP_ERR_UNKNOWN_TOPIC,                 // 未知的topic
  ACP_ERR_NOSUPPORT_CONNPROTOCOL,        // 不支持的通讯协议
  ACP_ERR_DATAPACKAGE_TOO_SMALL,         // 数据包长度太小了
  ACP_ERR_DATAPACKAGE_TOO_LONG,          // 数据包长度太大了
  ACP_ERR_SERIALIZED,                    // 序列化错误
  ACP_ERR_DESERIALIZED,                  // 反序列化错误
  ACP_ERR_HEADER_LEN_NOT_MATCH,          // acp header长度不匹配
  ACP_ERR_SEND_ERROR,                    // 发送消息失败
  ACP_ERR_INVAILD_PORT_RANGE,            // 无效的port范围,用户注册的port必须大于500
  ACP_ERR_MESSAGEID_NOT_MACTH,           // 接收到的消息Id不匹配

  // 内部API使用的相关错误码
  ACP_ERR_INVAILD_HANDLER = 0x2001,  // 无效的句柄
  ACP_ERR_INVAILD_NETADAPTER,        // 无效的网络适配器
  ACP_ERR_INIT_RESOURCE_ERROR,       // 初始化资源错误
  ACP_ERR_INVAILD_INPUT_PARAM,       // 无效的输入参数
  ACP_ERR_SERVER_NOT_RUNING,         // ACP服务未运行
  ACP_ERR_INVAILD_REQ_CMD,           // 无效的请求命令
  ACP_ERR_INVAILD_BUFF_LENGTH,       // 无效的buff的长度
  ACP_ERR_NOMEMORY,                  // 没有足够内存
  ACP_ERR_NO_DISK_SPACE,             // 没有足够的磁盘空间

  // 文件传输错误码
  ACP_ERR_FILESYSTEM_CREATEFILE_FAIL = 0x3000,  // 创建文件失败
  ACP_ERR_FILESYSTEM_FILEOPEN_FAIL,             // 文件打开失败
  ACP_ERR_FILESYSTEM_FILE_NO_EXIST,             // 文件不存在
  ACP_ERR_FILESYSTEM_FILEREAD_FAIL,             // 读文件错误
  ACP_ERR_FILESYSTEM_FILEWRITE_FAIL,            // 写文件错误
  ACP_ERR_FILESYSTEM_INVAILD_HANDLER,           // 无效的文件句柄
  ACP_ERR_FILESYSTEM_TRANSFER_FAULT,            // 传输错误

  // 组件相关的错误码
  ACP_ERR_CMP_UNREGISTER = 0X4001,     // 组件位注册
  ACP_ERR_CMP_CONN_ACPSERVER_TIMEOUT,  // 连接服务超时
  ACP_ERR_CMP_ALREADY_REGISTER,        // 组件已经注册
  ACP_ERR_CMP_OFFLINE,                 // 组件不在线
  ACP_ERR_CMP_NAME_ILLEGAL,            // 组件名称不合法的
};

#endif  // LIBACP_LIBACPERR_H_
